package com.bokesoft.yigo.meta.biz;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.charging.MetaChargingObjectList;
import com.bokesoft.yigo.meta.charging.MetaChargingRuleGroupList;

/**
 * MetaBizExtend定义业务扩展配置，设置这个类的目的主要是为了方便扩展的处理
 * @author wangyh
 *
 */
public class MetaBizExtend extends AbstractMetaObject implements IElementMerge<MetaBizExtend> {
	private MetaChargingObjectList chargingObjectList = null;
	private MetaChargingRuleGroupList chargingRuleGroupList = null;
	
	public MetaBizExtend() {
		super();
		this.chargingObjectList = new MetaChargingObjectList();
		this.chargingRuleGroupList = new MetaChargingRuleGroupList();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "BizExtend";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}
	
	/**
	 * 取得计费对象列表
	 * @return 计费对象列表
	 */
	public MetaChargingObjectList getCharginbObjectList() {
		return this.chargingObjectList;
	}
	
	/**
	 * 取得计费规则组列表
	 * @return 计费规则组列表
	 */
	public MetaChargingRuleGroupList getChargingRuleGroupList() {
		return this.chargingRuleGroupList;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBizExtend();
	}

	@Override
	public MetaBizExtend toMerge(MetaBizExtend obj) {
		if (obj != null) {
			if (chargingObjectList != null) {
				chargingObjectList.toMerge(obj.chargingObjectList);
			}
			if (chargingRuleGroupList != null) {
				chargingRuleGroupList.toMerge(obj.chargingRuleGroupList);
			}
		}
		
		return this;
	}

}
