package com.bokesoft.yigo.meta.app;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaApps定义一个Solution中的多应用配置
 * @author wangyh
 *
 */
public class MetaApps extends GenericNoKeyCollection<MetaApp> {
	/** 默认应用 */
	private String defaultApp = "";
	
	public MetaApps() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "Apps";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaApp.TAG_NAME.equals(tagName) ) {
			MetaApp app = new MetaApp();
			this.add(app);
			resultMetaObject = app;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaApps();
	}

	/**
	 * 设置默认应用
	 * @param defaultApp 默认应用标识
	 */
	public void setDefaultApp(String defaultApp) {
		this.defaultApp = defaultApp;
	}
	
	/**
	 * 取得默认应用
	 * @return 默认应用标识
	 */
	public String getDefaultApp() {
		return this.defaultApp;
	}
}
