package com.bokesoft.yes.meta.persist.dom.xml.parse;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.xml.ex.TextSyntaxException;

public class TextAnalyzer {
	private static TextAnalyzer sington = new TextAnalyzer();

	public static TextAnalyzer New() {
		return sington;
	}

	public Entry getBlank(String source, int bg) {
		int ed = source.length();

		int i = bg;

		for (; i < source.length(); i++) {
			char c = source.charAt(i);
			if (!CharUtil.isBlank(c)) {
				ed = i;
				break;
			}
		}

		if (ed <= bg) {
			return null;
		}

		Entry e = new Entry();
		e.setType(2);

		e.setBg(bg);
		e.setEd(ed - 1);

		return e;
	}

	public Entry getString(String source, int bg, char[] borderChar,
			char[] escape, boolean useLRLN) {
		boolean isStart = false;
		Entry entry = null;

		char useBorder = '"';

		int i = bg;

		for (; i < source.length(); i++) {
			char c = source.charAt(i);

			if (!isStart) {
				if (CharUtil.isBlank(c)) {
					continue;
				}
				if (CharUtil.isInIt(c, borderChar)) {
					isStart = true;

					useBorder = c;

					entry = new Entry();
					entry.setType(1);
					entry.setBg(i);
				} else {
					return null;
				}

			} else if (c == useBorder) {
				if (i == source.length() - 1) {
					entry.setEd(i);
					break;
				}
				if (CharUtil.isInIt(c, escape)) {
					if (source.charAt(i + 1) == c) {
						i++;
					} else {
						entry.setEd(i);
						break;
					}
				} else {
					entry.setEd(i);
					break;
				}
			} else if (CharUtil.isInIt(c, escape)) {
				i++;
			} else {
				if ((c != '\r') && (c != '\n'))
					continue;
				if (!useLRLN) {
					throw new TextSyntaxException("字符串不能换行[\\r\\n]\r\n["
							+ source.substring(bg, i)
							+ "\r\n^^^^^^^^^^^^^^^^^^^^^^^^^^\r\n"
							+ source.substring(i) + "]");
				}

			}

		}

		if (entry == null) {
			return null;
		}

		if (entry.getEd() == -1) {
			throw new TextSyntaxException("字符串没有正常的结束[\\r\\n]\r\n["
					+ source.substring(entry.getBg()) + "]");
		}

		return entry;
	}

	public Entry getCommonString(String source, int bg) {
		return getString(source, bg, new char[] { '"' }, new char[] { '\\' },
				false);
	}

	public Entry getXmlString(String source, int bg) {
		return getString(source, bg, new char[] { '"', '\'' }, null, true);
	}

	public Entry getSqlString(String source, int bg) {
		return getString(source, bg, new char[] { '\'' }, new char[] { '\\',
				'\'' }, false);
	}

	public Entry getName(String source, int bg, char[] wordChars,
			char[] endChars) {
		boolean isStart = false;

		Entry entry = new Entry();
		entry.setType(3);

		for (int i = bg; i < source.length(); i++) {
			char c = source.charAt(i);

			if (!isStart) {
				if (CharUtil.isBlank(c))
					continue;
				if (CharUtil.isNameStartChar(c)) {
					isStart = true;
					entry.setBg(i);
				} else {
					return null;
				}

			} else if ((!CharUtil.isNameChar(c))
					&& (!CharUtil.isInIt(c, wordChars))) {
				if ((CharUtil.isBlank(c)) || (CharUtil.isInIt(c, endChars))) {
					entry.setEd(i - 1);
					break;
				}
				throw new TextSyntaxException("元素名称，不能含有字符[" + c + "]\r\n["
						+ source.substring(bg, i)
						+ "\r\n^^^^^^^^^^^^^^^^^^^^^^^^^^\r\n"
						+ source.substring(i) + "]");
			}

		}

		if (entry.getBg() == -1) {
			return null;
		}

		if (entry.getEd() == -1) {
			entry.setEd(source.length() - 1);
		}

		return entry;
	}

	public Entry getComment(String source, int bg, String bgStr, String endStr) {
		boolean isStart = false;
		Entry entry = new Entry();
		entry.setType(4);

		for (int i = bg; i < source.length(); i++) {
			if (!isStart) {
				if (!StringUtil.isString(source, bgStr, i))
					continue;
				isStart = true;
				entry.setBg(i);
				i += bgStr.length() - 1;
			} else {
				if (!StringUtil.isString(source, endStr, i))
					continue;
				entry.setEd(i + (endStr.length() - 1));
				break;
			}

		}

		if (entry.getBg() == -1) {
			return null;
		}

		if (entry.getEd() == -1) {
			throw new TextSyntaxException("Comment元素没有结尾\r\n["
					+ source.substring(entry.getBg()) + "]");
		}

		return entry;
	}
}