package com.bokesoft.yes.meta.persist.dom.taskflow;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.taskflow.node.MetaPara;

public class MetaParaAction extends BaseDomAction<MetaPara> {

	@Override
	public void load(Document document, Element element, MetaPara meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.PARA_KEY, ""));
		meta.setValue(DomHelper.readAttr(element, MetaConstants.PARA_VALUE, ""));
		meta.setType(ParaType.parse(DomHelper.readAttr(element, MetaConstants.PARA_TYPE, "")));
	}

	@Override
	public void save(Document document, Element element, MetaPara meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.PARA_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.PARA_VALUE, meta.getValue(), "");
		DomHelper.writeAttr(element, MetaConstants.PARA_TYPE,  ParaType.format(meta.getType()), "");
	}
}
