package com.bokesoft.yes.meta.persist.dom.taskflow;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.taskflow.node.MetaJoin;

public class MetaJoinAction extends MetaNodeAction<MetaJoin> {
	
	@Override
	public void load(Document document, Element element, MetaJoin meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setJoinCount(DomHelper.readAttr(element, MetaConstants.JOIN_JOINCOUNT, -1));
	}

	@Override
	public void save(Document document, Element element, MetaJoin meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.JOIN_JOINCOUNT, meta.getJoinCount(), -1);
	}

}
