package com.bokesoft.yes.meta.persist.dom.task.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.task.node.MetaTaskJoin;

public class MetaTaskJoinAction extends MetaTaskNodeAction<MetaTaskJoin> {
	@Override
	public void load(Document doc, Element node, MetaTaskJoin meta, int runType) {
		meta.setJoinCount(DomHelper.readAttr(node, BPMConstants.NODE_JOINCOUNT, 1));
		super.load(doc, node, meta, runType);
	}
	
	@Override
	public void save(Document doc, Element node, MetaTaskJoin meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.NODE_JOINCOUNT, meta.getJoinCount(), 1);
		super.save(doc, node, meta, runType);
	}
}
