package com.bokesoft.yes.meta.persist.dom.solution;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.datamap.MetaDataMapProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaUserSVGFileScanLoad extends BaseMetaScanLoad {
	private int runType = AppRunType.App;
	private HashMapIgnoreCase<File> userSVGFileMap = null;
	private Map<String, File> map = null;
	
	public MetaUserSVGFileScanLoad(HashMapIgnoreCase<File> userSVGFileMap, IMetaResolver resolver, MetaProject metaProject, Object context, int runType) {
		super(resolver, metaProject, DomMetaConstants.FLATCANVAS_USER_FOLD, context);
		this.userSVGFileMap = userSVGFileMap;
		this.runType = runType;
		map = new ConcurrentHashMap<>();
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaDataMapProfile profile) {
	}

	protected void postLoad() throws Throwable {
		super.postLoad();
		merge();
	}
	
	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		try {
			File file = new File(resolver.getPath(filePath));
			map.put(fileName.toLowerCase(), file);
		} catch (Exception e) {
			e.printStackTrace();
			LogSvr.getInstance().error(resolver.getPath(filePath), e);
			throw e;
		} 
	}

	@Override
	protected String getFileFilter() {
		return ".svg";
	}
	
	public int getRunType() {
		return runType;
	}

	private void merge() {
		if(map.isEmpty()) {
			return;
		}
		try {
			userSVGFileMap.putAll(map);
		}finally {
			map.clear();
		}
	}
	
	public HashMapIgnoreCase<File> getMetaUserSVGFileMap() {
		merge();
		return this.userSVGFileMap;
	}
}

