package com.bokesoft.yes.meta.persist.dom.solution;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.solution.MetaStartItem;

public class MetaStartItemAction extends BaseDomAction<MetaStartItem> {

	@Override
	public void load(Document document, Element element, MetaStartItem meta, int runType) {
		meta.setPlatform(DomHelper.readAttr(element, "Platform", ""));
		meta.setStartForm(DomHelper.readAttr(element, "StartForm", ""));
		meta.setLoginForm(DomHelper.readAttr(element, "LoginForm", ""));
		meta.setAppKey(DomHelper.readAttr(element, "AppKey", ""));
	}

	@Override
	public void save(Document document, Element element, MetaStartItem meta, int runType) {
		DomHelper.writeAttr(element, "Platform", meta.getPlatform(), "");
		DomHelper.writeAttr(element, "StartForm", meta.getStartForm(), "");
		DomHelper.writeAttr(element, "LoginForm", meta.getLoginForm(), "");
		DomHelper.writeAttr(element, "AppKey", meta.getAppKey(), "");
	}

}
