package com.bokesoft.yes.meta.persist.dom.solution;

import java.io.InputStream;

import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.strings.MetaStringTable;

public class MetaProjectDataMigrationI18NScanLoad extends BaseMetaScanLoad {

	private MetaStringTable strings = null;
	
	public MetaProjectDataMigrationI18NScanLoad(MetaStringTable strings, IMetaResolver resolver, MetaProject metaProject, Object context) {
		super(resolver, metaProject, DomMetaConstants.DATAMIGRATION_FOLD, context);
		this.strings = strings;
	}
	
	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		// datamigration-lang.xml
		int firstIndex = fileName.indexOf('-');
		int secondIndex = fileName.lastIndexOf('.');
		String lang = fileName.substring(firstIndex + 1, secondIndex);
		InputStream in = resolver.read(filePath, 0);
		strings.load(lang, in);

		in.close();

	}

}
