package com.bokesoft.yes.meta.persist.dom.solution;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.json.JSONObject;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.flatcanvas.MetaFlatCanvasList;
import com.bokesoft.yigo.meta.flatcanvas.MetaFlatCanvasProfile;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCPaper;
import com.bokesoft.yigo.meta.flatcanvas.struct.FCAttrNames;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaFlatCanvasScanLoad extends BaseMetaScanLoad {
	private int runType = AppRunType.App;
	private MetaFlatCanvasList flatCanvasList = null;
	private Map<String, MetaFlatCanvasProfile> map = null;
	
	public MetaFlatCanvasScanLoad(MetaFlatCanvasList flatCanvasList, IMetaResolver resolver, MetaProject metaProject, Object context, int runType) {
		super(resolver, metaProject, DomMetaConstants.FLATCANVAS_FOLD, context);
		this.flatCanvasList = flatCanvasList;
		this.runType = runType;
		map = new ConcurrentHashMap<>();
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaFlatCanvasProfile profile) {
		
	}
	
	protected void postLoad() throws Throwable {
		super.postLoad();
		merge();
	}
	
	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		JSONObject profileInfo = resolver.readProfile(filePath, 0);
		if (profileInfo != null) {
			String tagName = profileInfo.optString(MetaConstants.COMMON_TAG_NAME);
			if (MetaFCPaper.TAG_NAME.equals(tagName)) {
				MetaFlatCanvasProfile profile = new MetaFlatCanvasProfile();
				profile.setKey(profileInfo.optString(FCAttrNames.ATTR_key));
				profile.setCaption(profileInfo.optString(FCAttrNames.ATTR_caption));
				profile.setProject(metaProject);
				profile.setResource(filePath);
				if ( map.containsKey(profile.getKey())) {
					MetaFlatCanvasProfile tmpFlatCanvasProfile = flatCanvasList.get(profile.getKey());
					IMetaProject tmpProject = tmpFlatCanvasProfile.getProject();
					throw new MetaException(MetaException.REPEAT_FLATCANVAS_DEFINED,
							SimpleStringFormat.format(StringTable.getString(null, "", StringTable.RepeatFlatCanvasDefined), 
									metaProject.getKey(), profile.getKey(),
									tmpProject.getKey()));
				}
				doFind(parent, parentPath, filePath, fileName, profile);
				map.put(profile.getKey(), profile);
			}
		}
	}
	
	public int getRunType() {
		return runType;
	}
	
	private void merge() {
		if(map.isEmpty()) {
			return;
		}
		try {
			flatCanvasList.putAll(map);
		}finally {
			map.clear();
		}
	}
	
	public MetaFlatCanvasList getMetaFlatCanvasList() {
		merge();
		return this.flatCanvasList;
	}
}
