package com.bokesoft.yes.meta.persist.dom.solution;

import org.json.JSONObject;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffList;
import com.bokesoft.yigo.meta.diff.MetaDiffProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaDiffScanLoad extends BaseMetaScanLoad {
	
	private MetaDiffList diffList = null;

	public MetaDiffScanLoad(MetaDiffList diffList,
			IMetaResolver resolver, MetaProject metaProject, Object context) {
		super(resolver, metaProject, DomMetaConstants.DIFF_FOLD, context);
		this.diffList = diffList;
	}

	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaDiffProfile profile) {
		
	}

	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		// 如果当前工程目录设置了差异工程,则在差异工程中加载差异
		if (metaProject.isReferOtherDiffProject()) {
			return;
		}
		
		JSONObject profileInfo = resolver.readProfile(filePath, 0);
		if (profileInfo != null) {
			String tagName = profileInfo.optString(MetaConstants.COMMON_TAG_NAME);
			if (MetaDiff.TAG_NAME.equals(tagName)) {
				MetaDiffProfile diffProfile = new MetaDiffProfile();
				diffProfile.setKey(profileInfo.optString(MetaConstants.COMMON_KEY));
				diffProfile.setCaption(profileInfo.optString(MetaConstants.COMMON_CAPTION));
				diffProfile.setResource(filePath);
				diffProfile.setProject(metaProject);
				if (diffList.containsKey(diffProfile.getKey())) {
					throw new MetaException(MetaException.REPEAT_FORM_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatFormDefined),
									metaProject.getKey(), diffProfile.getKey()));
				}
				doFind(parent, parentPath, filePath, fileName, diffProfile);
				diffList.add(diffProfile);
			}
		}
	}

}
