package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.MetaReportRowGroup;

public class MetaReportRowGroupAction extends MetaBaseScriptAction<MetaReportRowGroup> {
	@Override
	public void load(Document document, Element element, MetaReportRowGroup meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setTag(DomHelper.readAttr(element, MetaReportConstants.ROWGROUP_TAG, ""));
		meta.setItemKey(DomHelper.readAttr(element, MetaReportConstants.ROWGROUP_ITEMKEY, ""));
	}
	
	@Override
	public void save(Document document, Element element, MetaReportRowGroup meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaReportConstants.ROWGROUP_TAG, meta.getTag(), "");
		DomHelper.writeAttr(element, MetaReportConstants.ROWGROUP_ITEMKEY, meta.getItemKey(), "");
	}
}
