package com.bokesoft.yes.meta.persist.dom.midsetting;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.midsetting.MetaDataObjectProvider;

public class MetaDataObjectProviderAction extends BaseDomAction<MetaDataObjectProvider> {

	@Override
	public void load(Document document, Element element, MetaDataObjectProvider meta, int runType) {
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.COMMON_IMPL, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
	}

	@Override
	public void save(Document document, Element element, MetaDataObjectProvider meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_IMPL, meta.getImpl(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
	}

}
