package com.bokesoft.yes.meta.persist.dom.form.script;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaKeyHandler;

public class MetaKeyHandlerAction extends MetaBaseScriptAction<MetaKeyHandler> {
	@Override
	public void load(Document document, Element element, MetaKeyHandler meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
	}

	@Override
	public void save(Document document, Element element, MetaKeyHandler meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
	}
}
