package com.bokesoft.yes.meta.persist.dom.form.component.view.layout;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.TabMode;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTabLayout;

public class MetaTabLayoutAction extends MetaComponentLayoutAction {

	@Override
	public void load(Document document, Element element, AbstractMetaObject meta, int runType) {
		super.load(document, element, meta, runType);
		MetaTabLayout metaTabLayout = (MetaTabLayout) meta;
		metaTabLayout.setTabPosition(DirectionType
				.parse(DomHelper.readAttr(element, MetaConstants.TABPANEL_TABPOSITION, DirectionType.STR_TOP)));
		metaTabLayout.setTabMode(
				TabMode.parse(DomHelper.readAttr(element, MetaConstants.TABPANEL_TABMODE, TabMode.STR_Fixed)));
		metaTabLayout.setIndicatorHeight(
				DefSize.parse(DomHelper.readAttr(element, MetaConstants.TABPANEL_INDICATORHEIGHT, "")));
		metaTabLayout.setIndicatorColor(DomHelper.readAttr(element, MetaConstants.TABPANEL_INDICATORCOLOR, ""));
		metaTabLayout.setShowHead(DomHelper.readAttr(element, MetaConstants.TABPANEL_SHOWHEAD, true));
		metaTabLayout.setHoverHead(DomHelper.readAttr(element, MetaConstants.TABPANEL_HOVERHEAD, false));
	}

	@Override
	public void save(Document document, Element element, AbstractMetaObject meta, int runType) {
		super.save(document, element, meta, runType);
		MetaTabLayout metaTabLayout = (MetaTabLayout) meta;
		DomHelper.writeAttr(element, MetaConstants.TABPANEL_TABPOSITION,
				DirectionType.toString(metaTabLayout.getTabPosition()), DirectionType.STR_TOP);
		DomHelper.writeAttr(element, MetaConstants.TABPANEL_TABMODE, TabMode.toString(metaTabLayout.getTabMode()),
				TabMode.STR_Fixed);
		DomHelper.writeAttr(element, MetaConstants.TABPANEL_INDICATORHEIGHT,
				DefSize.toString(metaTabLayout.getIndicatorHeight()), "");
		DomHelper.writeAttr(element, MetaConstants.TABPANEL_INDICATORCOLOR, metaTabLayout.getIndicatorColor(), "");
		DomHelper.writeAttr(element, MetaConstants.TABPANEL_SHOWHEAD, metaTabLayout.isShowHead(), true);
		DomHelper.writeAttr(element, MetaConstants.TABPANEL_HOVERHEAD, metaTabLayout.isHoverHead(), false);
	}
}
