package com.bokesoft.yes.meta.persist.dom.form.component.view.layout;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutItem;

public class MetaLayoutItemAction extends BaseDomAction<AbstractMetaObject> {

	@Override
	public void load(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		MetaLayoutItem metaLayoutItem = (MetaLayoutItem)meta;
		metaLayoutItem.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		metaLayoutItem.setLoadTemp(document, element, runType);
	}

	@Override
	public void save(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		MetaLayoutItem metaLayoutItem = (MetaLayoutItem)meta;
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, metaLayoutItem.getKey(), "");
	}

}
