package com.bokesoft.yes.meta.persist.dom.form.component.view.layout;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutDirection;

public class MetaLayoutDirectionAction extends MetaLayoutItemAction {
	@Override
	public void load(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.load(document, element, meta, runType);
		MetaLayoutDirection metaLayoutDirection = (MetaLayoutDirection)meta;
		metaLayoutDirection.setValue(DirectionType.parse(DomHelper.readAttr(element, MetaConstants.LAYOUT_DIRECTION_VALUE, "")));
		String heightStr = DomHelper.readAttr(element, MetaConstants.COMMON_HEIGHT, "");
		if(!heightStr.isEmpty()){
			metaLayoutDirection.setHeight(DefSize.parse(heightStr));
		}
		String widthStr = DomHelper.readAttr(element, MetaConstants.COMMON_WIDTH, "");
		if(!widthStr.isEmpty()){
			metaLayoutDirection.setWidth(DefSize.parse(widthStr));
		}
	}

	@Override
	public void save(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.save(document, element, meta, runType);
		MetaLayoutDirection metaLayoutDirection = (MetaLayoutDirection)meta;
		DomHelper.writeAttr(element, MetaConstants.LAYOUT_DIRECTION_VALUE, DirectionType.toString(metaLayoutDirection.getValue()), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_HEIGHT, 
				metaLayoutDirection.getHeight() != null ? metaLayoutDirection.getHeight().toString() : "", "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_WIDTH, 
				metaLayoutDirection.getWidth() != null ? metaLayoutDirection.getWidth().toString() : "", "");
	}
}
