package com.bokesoft.yes.meta.persist.dom.form.component.panel.flexboxpanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.panel.MetaPanelAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.FlexBoxPanel.MetaFlexBoxPanel;

public class MetaFlexBoxPanelAction extends MetaPanelAction<MetaFlexBoxPanel> {
	
	@Override
	public void load(Document document, Element element, MetaFlexBoxPanel meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setRepeatCount(DomHelper.readAttr(element, MetaConstants.FLEXBOXPANEL_REPEATCOUNT, 3));
	}
	
	@Override
	public void save(Document document, Element element, MetaFlexBoxPanel meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.FLEXBOXPANEL_REPEATCOUNT, meta.getRepeatCount(), 3);
	}
}
