package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.GridTreeType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowTree;

public class MetaRowTreeAction extends MetaBaseScriptAction<MetaRowTree>{

	@Override
	public void load(Document document, Element element, MetaRowTree meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setTreeType(GridTreeType.parse(DomHelper.readAttr(element, MetaConstants.TREE_TYPE, GridTreeType.STR_NONE)));
		meta.setExpand(DomHelper.readAttr(element, MetaConstants.TREE_EXPAND, false));
		meta.setForeign(DomHelper.readAttr(element, MetaConstants.TREE_FOREIGN, ""));
		meta.setParent(DomHelper.readAttr(element, MetaConstants.TREE_PARENT, ""));
		meta.setCellKey(DomHelper.readAttr(element, MetaConstants.TREE_CELLKEY, ""));
		meta.setExpandLevel(DomHelper.readAttr(element, MetaConstants.TREE_EXPANDLEVEL, -1));
		meta.setLoadMethod(DomHelper.readAttr(element, MetaConstants.TREE_LOADMETHOD, ""));
        meta.setImage(DomHelper.readAttr(element, MetaConstants.TREE_IMAGE, ""));
		meta.setOnlyExpand(DomHelper.readAttr(element, MetaConstants.TREE_ONLYEXPAND, false));
	}

	@Override
	public void save(Document document, Element element, MetaRowTree meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.TREE_TYPE, GridTreeType.toString(meta.getTreeType()), GridTreeType.STR_NONE);
		DomHelper.writeAttr(element, MetaConstants.TREE_EXPAND, meta.isExpand(), false);
		DomHelper.writeAttr(element, MetaConstants.TREE_FOREIGN, meta.getForeign(), "");
		DomHelper.writeAttr(element, MetaConstants.TREE_PARENT, meta.getParent(), "");
		DomHelper.writeAttr(element, MetaConstants.TREE_CELLKEY, meta.getCellKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TREE_EXPANDLEVEL, meta.getExpandLevel(), -1);
        DomHelper.writeAttr(element, MetaConstants.TREE_LOADMETHOD, meta.getLoadMethod(), "");
        DomHelper.writeAttr(element, MetaConstants.TREE_IMAGE, meta.getImage(), "");
		DomHelper.writeAttr(element, MetaConstants.TREE_ONLYEXPAND, meta.getOnlyExpand(), false);
	}

}
