package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentExtAction;
import com.bokesoft.yigo.common.def.PageLoadType;
import com.bokesoft.yigo.common.def.SelectionMode;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;

public class MetaGridExtAction extends MetaComponentExtAction<MetaGrid> {
	
	@Override
	public void load(Document document, Element element, MetaGrid meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setPageLoadType(PageLoadType.parse(DomHelper.readAttr(element, MetaConstants.GRID_PAGELOADTYPE, "")));
		meta.setPageRowCount(DomHelper.readAttr(element, MetaConstants.GRID_PAGEROWCOUNT, -1));
		meta.setPageIndicatorCount(DomHelper.readAttr(element, MetaConstants.GRID_PAGEINDICATORCOUNT, -1));
		meta.setRowRange(DomHelper.readAttr(element, MetaConstants.GRID_ROWRANGE, null));
		meta.setNewEmptyRow(DomHelper.readAttr(element, MetaConstants.GRID_NEW_EMPTY_ROW, null));
		meta.setShowRowHead(DomHelper.readBool(element, MetaConstants.GRID_SHOW_ROW_HEAD, null));
		meta.setHideGroup4Editing(DomHelper.readBool(element, MetaConstants.GRID_HIDE_GROUP_4_EDITING, null));
		meta.setSelectMode(SelectionMode.parse(DomHelper.readAttr(element, MetaConstants.SELECTION_MODE, "")));
		meta.setSerialSeq(DomHelper.readBool(element, MetaConstants.GRID_SERIALSEQ, null));
		meta.setSerialRowNum(DomHelper.readBool(element, MetaConstants.GRID_SERIALROWNUM, null));
		meta.setEndEditByNav(DomHelper.readBool(element, MetaConstants.GRID_ENDEDITBYNAV, null));
		meta.setAddDataRow(DomHelper.readBool(element, MetaConstants.GRID_ADDDATAROW, null));
		meta.setDefaultFitWidth(DomHelper.readBool(element, MetaConstants.GRID_DEFAULTFITWIDTH, null));
		meta.setDisabledOption(DomHelper.readAttr(element, MetaConstants.GRID_DISABLEOPTION, null));
		meta.setOption(DomHelper.readAttr(element, MetaConstants.GRID_OPTION, null));
		meta.setGridDefaultSortField(DomHelper.readAttr(element, MetaConstants.GRID_GRIDSORT, null));
	}
	
	@Override
	public void save(Document document, Element element, MetaGrid meta, int runType) {
		
		
	}
}