package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import java.util.HashMap;

import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.*;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.MetaDynamicPropertiesAction;
import com.bokesoft.yigo.common.def.CellType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.GroupType;
import com.bokesoft.yigo.common.def.SortType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;

public class MetaGridCellAction extends BaseDomAction<MetaGridCell> {
    private HashMap<Integer, BaseDomAction<AbstractMetaObject>> actionMap = null;
    @SuppressWarnings("unchecked")
    public MetaGridCellAction() {
        super();
        actionMap = new HashMap<Integer, BaseDomAction<AbstractMetaObject>>();
        Object[][] v = new Object[][] {
                { ControlType.LABEL, new MetaLabelPropertiesAction() },
                { ControlType.PRICELABEL, new MetaPriceLabelPropertiesAction() },
                { ControlType.RELATIVETIME, new MetaRelativeTimePropertiesAction() },
                { ControlType.BUTTON, new MetaButtonPropertiesAction() },
                { ControlType.NOTICEBAR, new MetaNoticeBarPropertiesAction() },
                { ControlType.BARCODER, new MetaBarCoderPropertiesAction() },
                { ControlType.TOGGLEBUTTON, new MetaToggleButtonPropertiesAction() },
                { ControlType.MULTISTATEBUTTON, new MetaMultiStateButtonPropertiesAction() },
                { ControlType.TEXTEDITOR, new MetaTextEditorPropertiesAction() },
                { ControlType.TEXTBUTTON, new MetaTextButtonPropertiesAction() },
                { ControlType.NUMBEREDITOR, new MetaNumberEditorPropertiesAction() },
                { ControlType.CHECKBOX, new MetaCheckBoxPropertiesAction() },
                { ControlType.DICT, new MetaDictPropertiesAction() },
                { ControlType.DATEPICKER, new MetaDatePickerPropertiesAction() },
                { ControlType.UTCDATEPICKER, new MetaUTCDatePickerPropertiesAction()},
                { ControlType.COMBOBOX, new MetaComboBoxPropertiesAction() },
                { ControlType.CHECKLISTBOX, new MetaCheckListBoxPropertiesAction() },
                { ControlType.IMAGE, new MetaImagePropertiesAction() },
                { ControlType.VIDEOPLAYER, new MetaVideoPlayerPropertiesAction() },
                { ControlType.HYPERLINK, new MetaHyperLinkPropertiesAction() },
                { ControlType.COMPDICT,new MetaDictPropertiesAction()},
                { ControlType.DYNAMICDICT,new MetaDictPropertiesAction()},
                { ControlType.CUSTOM, new MetaCustomPropertiesAction() },
                { ControlType.DYNAMIC, new MetaDynamicPropertiesAction() },
                { ControlType.TEXTAREA, new MetaTextAreaPropertiesAction() },
                { ControlType.MONTHPICKER, new MetaMonthPickerPropertiesAction() },
                { ControlType.TIMEPICKER, new MetaTimePickerPropertiesAction() },
                { ControlType.ICON, new MetaIconPropertiesAction() },
                { ControlType.IMAGELIST, new MetaImageListPropertiesAction() },
                { ControlType.STEPEDITOR, new MetaStepEditorPropertiesAction() },
                { ControlType.UPLOADBUTTON, new MetaUploadButtonPropertiesAction() },
                { ControlType.WIZARDLIST, new MetaWizardListPropertiesAction() },
                { ControlType.RADIOBUTTON, new MetaRadioButtonPropertiesAction() },
        };
        for (Object[] l : v) {
            Integer type = (Integer) l[0];
            BaseDomAction<AbstractMetaObject> action = (BaseDomAction<AbstractMetaObject>) l[1];
            actionMap.put(type, action);
        }
    }

    @Override
    public void load(Document document, Element element, MetaGridCell meta, int runType) {
        meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
        meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
        meta.setCaptionFull(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_FULL, ""));
        meta.setCaptionEn(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN, ""));
        meta.setCaptionEnFull(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN_FULL, ""));
        meta.setEnable(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE, ""));
        meta.setEnableDependency(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, ""));
        meta.setCellType(CellType.parse(DomHelper.readAttr(element, MetaConstants.CELL_TYPE, ControlType.STR_LABEL)));
        meta.setIsMerged(DomHelper.readAttr(element, MetaConstants.IS_MERGED, false));
        meta.setIsMergedHead(DomHelper.readAttr(element, MetaConstants.IS_MERGED_HEAD, false));
        meta.setMergedRowSpan(DomHelper.readAttr(element, MetaConstants.MERGED_ROW_SPAN, 1));
        meta.setMergedColumnSpan(DomHelper.readAttr(element, MetaConstants.MERGED_COLUMN_SPAN, 1));
        meta.setCellGroupType(GroupType.parse(DomHelper.readAttr(element, MetaConstants.CELL_GROUP_TYPE, GroupType.STR_None)));
        meta.setKeywords(DomHelper.readAttr(element, MetaConstants.COMMON_KEYWORDS, ""));
        meta.setMerge(DomHelper.readAttr(element, MetaConstants.MERGE, false));
        meta.setMergeGroup(DomHelper.readAttr(element, MetaConstants.MERGEGROUP, false));

        meta.setSelect(DomHelper.readAttr(element, MetaConstants.IS_SELECT, false));
        meta.setSingleSelect(DomHelper.readAttr(element, MetaConstants.SINGLE_SELECT, false));
        String cssClass = DomHelper.readAttr(element, MetaConstants.COMPONENT_CLASS, "");
        if (StringUtils.isBlank(cssClass)) {
            cssClass = DomHelper.readAttr(element, MetaConstants.OPERATION_CSSCLASS, "");
        }
        meta.setCssClass(cssClass);
        meta.setForeColor(DomHelper.readAttr(element, MetaConstants.COMMON_FORECOLOR, ""));
        meta.setBackColor(DomHelper.readAttr(element, MetaConstants.COMMON_BACKCOLOR, ""));
        meta.setCellSortType(SortType.parse(DomHelper.readAttr(element, MetaConstants.CELL_SORTYPE, SortType.STR_Asc)));
        meta.setCellGroupItemKey(DomHelper.readAttr(element, MetaConstants.CELL_GROUPITEMKEY, ""));

        meta.setAsQuery(DomHelper.readAttr(element, MetaConstants.COMPONENT_ASQUERY, false));
        meta.setCopyNew(DomHelper.readAttr(element, MetaConstants.COMPONENT_COPYNEW, true));
        meta.setToolTip(DomHelper.readAttr(element, MetaConstants.COMPONENT_TOOLTIP, ""));
        meta.setFormulaTip(DomHelper.readAttr(element, MetaConstants.COMPONENT_FORMULATIP, ""));

        //属性
        meta.ensureProperties();
        //加载属性
        BaseDomAction<AbstractMetaObject> action = actionMap.get(meta.getCellType());
        if ( action != null ) {
            action.load(document, element, meta.getProperties(), runType);
            if(meta.getCellType() == ControlType.COMPDICT){
                MetaDictProperties dictPro = (MetaDictProperties) meta.getProperties();
                dictPro.setCompDict(true);
            }else if(meta.getCellType() == ControlType.DYNAMICDICT){
                MetaDictProperties dictPro = (MetaDictProperties) meta.getProperties();
                dictPro.setDynamic(true);
            }
        }
    }

    @Override
    public void save(Document document, Element element, MetaGridCell meta, int runType) {
        DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION_FULL, meta.getCaptionFull(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION_EN, meta.getCaptionEn(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION_EN_FULL, meta.getCaptionEnFull(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_ENABLE, meta.getEnable(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, meta.getEnableDependency(), "");
        DomHelper.writeAttr(element, MetaConstants.CELL_TYPE, CellType.toString(meta.getCellType()), ControlType.STR_LABEL);
        DomHelper.writeAttr(element, MetaConstants.IS_MERGED, meta.isMerged(), false);
        DomHelper.writeAttr(element, MetaConstants.IS_MERGED_HEAD, meta.isMergedHead(), false);
        DomHelper.writeAttr(element, MetaConstants.MERGED_ROW_SPAN, meta.getMergedRowSpan(), 1);
        DomHelper.writeAttr(element, MetaConstants.MERGED_COLUMN_SPAN, meta.getMergedColumnSpan(), 1);
        DomHelper.writeAttr(element, MetaConstants.CELL_GROUP_TYPE, GroupType.toString(meta.getCellGroupType()), GroupType.STR_None);
        DomHelper.writeAttr(element, MetaConstants.IS_SELECT, meta.isSelect(), false);
        DomHelper.writeAttr(element, MetaConstants.SINGLE_SELECT, meta.singleSelect(), false);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_CLASS, meta.getCssClass(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_FORECOLOR, meta.getForeColor(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_BACKCOLOR, meta.getBackColor(), "");
        DomHelper.writeAttr(element, MetaConstants.CELL_SORTYPE, SortType.toString(meta.getCellSortType()), SortType.STR_Asc);
        DomHelper.writeAttr(element, MetaConstants.CELL_GROUPITEMKEY, meta.getCellGroupItemKey(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_KEYWORDS, meta.getKeywords(), "");
        DomHelper.writeAttr(element, MetaConstants.MERGE, meta.isMerge(), false);
        DomHelper.writeAttr(element, MetaConstants.MERGEGROUP, meta.isMergeGroup(), false);

        DomHelper.writeAttr(element, MetaConstants.COMPONENT_ASQUERY, meta.isAsQuery(), false);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_COPYNEW, meta.isCopyNew(), true);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_TOOLTIP, meta.getToolTip(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_FORMULATIP, meta.getFormulaTip(), "");
        BaseDomAction<AbstractMetaObject> action = actionMap.get(meta.getCellType());

        // 设计器里新增的单元格,因为没有经过load(),没有属性类
        meta.ensureProperties();

        if ( action != null ) {
            action.save(document, element, meta.getProperties(), runType);
        }
    }

}