package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ColumnExpandType;
import com.bokesoft.yigo.common.def.ExpandSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaColumnExpand;

public class MetaColumnExpandAction extends MetaBaseScriptAction<MetaColumnExpand>{
	
	@Override
	public void load(Document document, Element element, MetaColumnExpand meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setExpandType(ColumnExpandType.parse(DomHelper.readAttr(element, MetaConstants.EXPAND_TYPE, ColumnExpandType.STR_DATA)));
		meta.setExpandSourceType(ExpandSourceType.parse(DomHelper.readAttr(element, MetaConstants.EXPAND_SOURCE_TYPE, ExpandSourceType.STR_CUSTOM)));
		meta.setExpandDependency(DomHelper.readAttr(element, MetaConstants.EXPAND_DEPENDENCY, ""));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_TABLEKEY, ""));
		meta.setColumnKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_COLUMNKEY, ""));
		meta.setItemKey(DomHelper.readAttr(element, MetaConstants.DICT_ITEMKEY, ""));
	}
	
	@Override
	public void save(Document document, Element element, MetaColumnExpand meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.EXPAND_TYPE, ColumnExpandType.toString(meta.getExpandType()), ColumnExpandType.STR_DATA);
		DomHelper.writeAttr(element, MetaConstants.EXPAND_SOURCE_TYPE, ExpandSourceType.toString(meta.getExpandSourceType()), ExpandSourceType.STR_CUSTOM);
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_COLUMNKEY, meta.getColumnKey(), "");
		DomHelper.writeAttr(element, MetaConstants.EXPAND_DEPENDENCY, meta.getExpandDependency(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_ITEMKEY, meta.getItemKey(), "");
	}

}
