package com.bokesoft.yes.meta.persist.dom.form.component.control.wizardlist;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardItem;

public class MetaWizardItemAction extends BaseDomAction<MetaWizardItem> {

	@Override
	public void load(Document document, Element element, MetaWizardItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaptionFieldKey(DomHelper.readAttr(element, MetaConstants.WIZARDLIST_CAPTIONFIELDKEY, ""));
		meta.setValueFieldKey(DomHelper.readAttr(element, MetaConstants.WIZARDLIST_VALUEFIELDKEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaWizardItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.WIZARDLIST_CAPTIONFIELDKEY, meta.getCaptionFieldKey(), "");
		DomHelper.writeAttr(element, MetaConstants.WIZARDLIST_VALUEFIELDKEY, meta.getValueFieldKey(), "");
	}
}
