package com.bokesoft.yes.meta.persist.dom.form.component.control.tableview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.PageLoadType;
import com.bokesoft.yigo.common.def.SubDetailLinkType;
import com.bokesoft.yigo.common.def.TableRowStyle;
import com.bokesoft.yigo.common.def.TableViewRowType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;

public class MetaTableRowAction extends MetaComponentAction<MetaTableRow> {

	@Override
	public void load(Document document, Element element, MetaTableRow meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setRowType(TableViewRowType.parse(DomHelper.readAttr(element, MetaConstants.ROW_TYPE, TableViewRowType.STR_Fix)));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_TABLEKEY, ""));
		meta.setStyle(TableRowStyle.parse(DomHelper.readAttr(element, MetaConstants.TABLEROW_STYLE, TableRowStyle.STR_List)));
		meta.setGroupColumnKeys(DomHelper.readAttr(element, MetaConstants.TABLEROW_GROUPCOLUMNKEYS, ""));
		meta.setColumnCount(DomHelper.readAttr(element, MetaConstants.COLUMNCOUNT, 3));
		meta.setSeparatorStyle(DomHelper.readAttr(element, MetaConstants.TABLEROW_SEPARATORSTYLE, ""));
		meta.setSeparatorRadius(DomHelper.readAttr(element, MetaConstants.TABLEROW_SEPARATORRADIUS, -1));
		meta.setSeparatorColor(DomHelper.readAttr(element, MetaConstants.TABLEROW_SEPARATORCOLOR, ""));
		String separatorOffsetStr = DomHelper.readAttr(element, MetaConstants.TABLEROW_SEPARATOROFFEST, "");
		if(separatorOffsetStr != null && separatorOffsetStr.length() > 0){
			meta.setSeparatorOffset(DefSize.parse(separatorOffsetStr));
		}
		meta.setTopMargin(DomHelper.readAttr(element, MetaConstants.TABLEROW_TOPMARGIN, ""));
		meta.setShowFirstMargin(DomHelper.readAttr(element, MetaConstants.TABLEROW_SHOWFIRSTMARGIN, false));
		meta.setSelectColor(DomHelper.readAttr(element, MetaConstants.TABLEROW_SELECTCOLOR, ""));
		meta.setHighlightColor(DomHelper.readAttr(element, MetaConstants.TABLEROW_HIGHLIGHTCOLOR, ""));
		meta.setBackColor(DomHelper.readAttr(element, MetaConstants.COMMON_BACKCOLOR, ""));
		meta.setIndicator(DomHelper.readAttr(element, MetaConstants.TABLEROW_INDICATOR, false));
		meta.setHoverHead(DomHelper.readAttr(element, MetaConstants.TABLEROW_HOVERHEAD, false));
		meta.setIndicatorKey(DomHelper.readAttr(element, MetaConstants.TABLEROW_INDICATOR_KEY, ""));
		meta.setGroupCollapse(DomHelper.readAttr(element, MetaConstants.TABLEROW_GROUPCOLLAPSE, false));
		meta.setPromptImage(DomHelper.readAttr(element, MetaConstants.LISTVIEW_PROMPTIMAGE, ""));
		meta.setPromptRowCount(DomHelper.readAttr(element, MetaConstants.LISTVIEW_PROMPTROWCOUNT, MetaTableRow.DEFAULT_PROMPT_ROW_COUNT));
		meta.setPageRowCount(DomHelper.readAttr(element, MetaConstants.LISTVIEW_PAGEROWCOUNT, 50));
		meta.setPageLoadType(PageLoadType.parse(DomHelper.readAttr(element, MetaConstants.LISTVIEW_PAGELOADTYPE, PageLoadType.STR_NONE)));
		meta.setShowTotalRowCount(DomHelper.readBool(element, MetaConstants.TABLEROW_SHOWTOTALROWCOUNT, (Boolean)null));
		meta.setLinkType(SubDetailLinkType.parse(DomHelper.readAttr(element, MetaConstants.LINK_TYPE, SubDetailLinkType.STR_Parent)));
		meta.setSource(DomHelper.readAttr(element, MetaConstants.SOURCE_FIELDS, ""));
		meta.setTarget(DomHelper.readAttr(element, MetaConstants.TARGET_FIELDS, ""));
		meta.setLinkList(DomHelper.readAttr(element, MetaConstants.TABLEROW_LINKLIST, ""));
		meta.setLinkFields(DomHelper.readAttr(element, MetaConstants.TABLEROW_LINKFIELDS, ""));
	}

	@Override
	public void save(Document document, Element element, MetaTableRow meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.ROW_TYPE, TableViewRowType.toString(meta.getRowType()), TableViewRowType.STR_Fix);
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_STYLE, TableRowStyle.toString(meta.getStyle()), TableRowStyle.STR_List);
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_GROUPCOLUMNKEYS, meta.getGroupColumnKeys(), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMNCOUNT, meta.getColumnCount(), 3);
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SEPARATORSTYLE, meta.getSeparatorStyle(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SEPARATORRADIUS, meta.getSeparatorRadius(), -1);
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SEPARATORCOLOR, meta.getSeparatorColor(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SEPARATOROFFEST,
				meta.getSeparatorOffset() == null ? "" : meta.getSeparatorOffset().toString(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_TOPMARGIN, meta.getTopMargin(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SHOWFIRSTMARGIN, meta.isShowFirstMargin(), false);
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SELECTCOLOR, meta.getSelectColor(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_HIGHLIGHTCOLOR, meta.getHighlightColor(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_BACKCOLOR, meta.getBackColor(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_INDICATOR, meta.isIndicator(), false);
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_HOVERHEAD, meta.isHoverHead(), false);
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_INDICATOR_KEY, meta.getIndicatorKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_GROUPCOLLAPSE, meta.isGroupCollapse(), false);
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_PROMPTIMAGE, meta.getPromptImage(), "");
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_PROMPTROWCOUNT, meta.getPromptRowCount(), MetaTableRow.DEFAULT_PROMPT_ROW_COUNT);
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_PAGEROWCOUNT, meta.getPageRowCount(), 50);
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_PAGELOADTYPE, PageLoadType.toString(meta.getPageLoadType()), PageLoadType.STR_NONE);
		DomHelper.writeAttr(element, MetaConstants.LINK_TYPE, SubDetailLinkType.toString(meta.getLinkType()), SubDetailLinkType.STR_Parent);
		DomHelper.writeAttr(element, MetaConstants.SOURCE_FIELDS, meta.getSource(), "");
		DomHelper.writeAttr(element, MetaConstants.TARGET_FIELDS, meta.getTarget(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SHOWTOTALROWCOUNT, meta.isShowTotalRowCount(), null);
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_LINKLIST, meta.getLinkList(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_LINKFIELDS, meta.getLinkFields(), "");
	}

}
