package com.bokesoft.yes.meta.persist.dom.form.component.control.shrinkview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaShrinkView;

public class MetaShrinkViewAction extends MetaComponentAction<MetaShrinkView> {

	@Override
	public void load(Document document, Element element, MetaShrinkView meta, int runType) {
		super.load(document, element, meta, runType);
		String toolBarHeight = DomHelper.readAttr(element, MetaConstants.SHRINKVIEW_TOOLBARHEIGHT, "");
		if (toolBarHeight != null && !toolBarHeight.isEmpty()) {
			meta.setToolBarHeight(DefSize.parse(toolBarHeight));
		}
		meta.setToolBarBackColor(DomHelper.readAttr(element, MetaConstants.SHRINKVIEW_TOOLBARBACKCOLOR, ""));
	}

	@Override
	public void save(Document document, Element element, MetaShrinkView meta, int runType) {
		super.save(document, element, meta, runType);

		DefSize toolBarHeight = meta.getToolBarHeight();
		if (toolBarHeight != null) {
			DomHelper.writeAttr(element, MetaConstants.SHRINKVIEW_TOOLBARHEIGHT, toolBarHeight.toString(), "");
		}
		DomHelper.writeAttr(element, MetaConstants.SHRINKVIEW_TOOLBARBACKCOLOR, meta.getToolBarBackColor(), "");
	}
}
