package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.PasswordEditorStyle;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPasswordEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;

public class MetaPasswordEditorExtPropertiesAction extends MetaTextEditorExtPropertiesAction{

	@Override
	public void loadImpl(Document document, Element element, MetaTextEditorProperties meta, int runType) {
		super.loadImpl(document, element, meta, runType);
		((MetaPasswordEditorProperties)meta).setSafeInput(DomHelper.readBool(element, MetaConstants.PASSWORDEDITOR_SAFEINPUT, null));
		((MetaPasswordEditorProperties)meta).setShowSwitchIcon(DomHelper.readBool(element, MetaConstants.PASSWORDEDITOR_SHOWSWITCHICON, null));
		((MetaPasswordEditorProperties)meta).setStyle(PasswordEditorStyle.parse(DomHelper.readAttr(element, MetaConstants.PASSWORDEDITOR_STYLE, null)));
		((MetaPasswordEditorProperties)meta).setShowPlainText(DomHelper.readBool(element, MetaConstants.PASSWORDEDITOR_SHOWPLAINTEXT, null));
		String spacingStr = DomHelper.readAttr(element, MetaConstants.PASSWORDEDITOR_SHOWSWITCHICON, null);
		((MetaPasswordEditorProperties)meta).setSpacing(spacingStr == null ? null : DefSize.parse(spacingStr));
		
	}
}
