package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.DomPropertiesAction;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ComboBoxTextShowType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;

public class MetaComboBoxExtPropertiesAction extends DomPropertiesAction<MetaComboBoxProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaComboBoxProperties meta, int runType) {
		meta.setEditable(DomHelper.readBool(element, MetaConstants.COMBOBOX_EDITABLE, null));
		meta.setItemsDependency(DomHelper.readAttr(element, MetaConstants.COMBOBOX_ITEMS_DEPENDENCY, null));
		meta.setSourceType(ComboBoxSourceType.parse(DomHelper.readAttr(element, MetaConstants.COMBOBOX_SOURCETYPE, "")));
		meta.setGroupKey(DomHelper.readAttr(element, MetaConstants.COMBOBOX_GROUPKEY, null));
		meta.setGlobalItems(DomHelper.readAttr(element, MetaConstants.COMBOBOX_GLOBAL_ITEMS, null));
		meta.setIntegerValue(DomHelper.readBool(element, MetaConstants.COMBOBOX_INTEGER_VALUE, null));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.TEXT_PROMPTTEXT, null));
		meta.setCache(DomHelper.readBool(element, MetaConstants.COMBOBOX_CACHE, null));
		meta.setTextShowType(ComboBoxTextShowType.parse(DomHelper.readAttr(element, MetaConstants.COMBOBOX_TEXTSHOWTYPE, "")));
		meta.setPromptSize(DomHelper.readInt(element, MetaConstants.COMBOBOX_PROMPTSIZE, -1));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaComboBoxProperties meta, int runType) {
		
	}

}
