package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.EditorImeOptions;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaTextEditor;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;

public class MetaTextEditorPropertiesAction extends DomPropertiesAction<MetaTextEditorProperties> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaTextEditorProperties meta, int runType) {
		meta.setMaxLength(DomHelper.readAttr(element, MetaConstants.TEXT_MAXLENGTH, 255));
		meta.setShowWordLimit(DomHelper.readBool(element, MetaConstants.TEXT_SHOWWORDLIMIT, false));
		meta.setCaseType(MetaTextEditor.parseCaseType(DomHelper.readAttr(element, MetaConstants.TEXT_CASE, "None")));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.TEXT_PROMPTTEXT, ""));
		meta.setInvalidChars(DomHelper.readAttr(element, MetaConstants.TEXT_INVALIDCHARS, ""));
		meta.setTrim(DomHelper.readAttr(element, MetaConstants.TEXT_TRIM, false));
		meta.setMask(DomHelper.readAttr(element, MetaConstants.TEXT_MASK, ""));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.TEXT_ICON, ""));
		meta.setPreIcon(DomHelper.readAttr(element, MetaConstants.TEXT_PREICON, ""));
		meta.setEmbedText(DomHelper.readAttr(element, MetaConstants.TEXT_EMBEDTEXT, ""));
		meta.setHoldFocus(DomHelper.readAttr(element, MetaConstants.TEXT_HOLDFOCUS, false));
		meta.setEmbedTextSize(DomHelper.readAttr(element, MetaConstants.TEXT_EMBEDTEXTSIZE, -1));
		meta.setEmbedTextColor(DomHelper.readAttr(element, MetaConstants.TEXT_EMBEDTEXTCOLOR, ""));
		meta.setImeOptions(EditorImeOptions.parse(DomHelper.readAttr(element, MetaConstants.TEXT_IMEOPTIONS, "")));
		meta.setSelectOnFocus(DomHelper.readAttr(element, MetaConstants.TEXT_SELECTONFOCUS, true));
		meta.setDisableKeyboard(DomHelper.readBool(element, MetaConstants.TEXT_DISABLEKEYBOARD, null));
		meta.setSuffix(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_SUFFIX, ""));
		meta.setPrefix(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_PREFIX, ""));
		// 移动端特殊处理
		if( element.hasAttribute(MetaConstants.TEXT_SELECTONFOCUS) ) {
			meta.setMobileSelectOnFocus(Boolean.parseBoolean(element.getAttribute(MetaConstants.TEXT_SELECTONFOCUS)));
		}
	}
	
	@Override
	public void saveImpl(Document document, Element element,
			MetaTextEditorProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.TEXT_MAXLENGTH, meta.getMaxLength(), 255);
		DomHelper.writeAttr(element, MetaConstants.TEXT_SHOWWORDLIMIT, meta.isShowWordLimit(), false);
		DomHelper.writeAttr(element, MetaConstants.TEXT_CASE, MetaTextEditor.getCaseTypeStr(meta.getCaseType()), "None");
		DomHelper.writeAttr(element, MetaConstants.TEXT_PROMPTTEXT, meta.getPromptText(), "");
		DomHelper.writeAttr(element, MetaConstants.TEXT_INVALIDCHARS, meta.getInvalidChars(), "");
		DomHelper.writeAttr(element, MetaConstants.TEXT_TRIM, meta.isTrim(),false);
		DomHelper.writeAttr(element, MetaConstants.TEXT_SELECTONFOCUS, meta.isSelectOnFocus(),true);
		DomHelper.writeAttr(element, MetaConstants.TEXT_MASK, meta.getMask(),"");
		DomHelper.writeAttr(element, MetaConstants.TEXT_ICON, meta.getIcon(),"");
		DomHelper.writeAttr(element, MetaConstants.TEXT_PREICON, meta.getPreIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.TEXT_EMBEDTEXT, meta.getEmbedText(),"");
		DomHelper.writeAttr(element, MetaConstants.TEXT_HOLDFOCUS, meta.isHoldFocus(), false);
		DomHelper.writeAttr(element, MetaConstants.TEXT_EMBEDTEXTSIZE, meta.getEmbedTextSize(),-1);
		DomHelper.writeAttr(element, MetaConstants.TEXT_EMBEDTEXTCOLOR, meta.getEmbedTextColor(),"");
		DomHelper.writeAttr(element, MetaConstants.TEXT_IMEOPTIONS, EditorImeOptions.toString(meta.getImeOptions()),"");
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_SUFFIX, meta.getSuffix(),"");
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_PREFIX, meta.getPrefix(),"");
		if(meta.isDisableKeyboard() != null){
			DomHelper.writeAttr(element, MetaConstants.TEXT_DISABLEKEYBOARD, meta.isDisableKeyboard().toString(), "");
		}
	}

}
