package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSearchBoxProperties;

public class MetaSearchBoxPropertiesAction extends DomPropertiesAction<MetaSearchBoxProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaSearchBoxProperties meta, int runType) {
		meta.setProviderKey(DomHelper.readAttr(element, MetaConstants.SEARCHBOX_PROVIDERKEY, ""));
		meta.setProviderFormulaKey(DomHelper.readAttr(element, MetaConstants.SEARCHBOX_PROVIDERFORMULAKEY, ""));
		meta.setProviderDependency(DomHelper.readAttr(element, MetaConstants.SEARCHBOX_PROVIDERDEPENDENCY, ""));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaSearchBoxProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.SEARCHBOX_PROVIDERKEY, meta.getProviderKey(), "");
		DomHelper.writeAttr(element, MetaConstants.SEARCHBOX_PROVIDERFORMULAKEY, meta.getProviderFormulaKey(), "");
		DomHelper.writeAttr(element, MetaConstants.SEARCHBOX_PROVIDERDEPENDENCY, meta.getProviderDependency(), "");
	}

}
