package com.bokesoft.yes.meta.persist.dom.form.component.control.moduleeditor;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.ModuleSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.moduleeditor.MetaModuleEditor;

public class MetaModuleEditorAction extends MetaComponentAction<MetaModuleEditor> {
	@Override
	public void load(Document document, Element element, MetaModuleEditor meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setSourceType(ModuleSourceType
				.parse(DomHelper.readAttr(element, MetaConstants.MODULEEDITOR_SOURCETYPE, ModuleSourceType.STR_ITEMS)));
		meta.setSourceCaption(DomHelper.readAttr(element, MetaConstants.MODULEEDITOR_SOURCECAPTION, ""));
		meta.setSourceTableKey(DomHelper.readAttr(element, MetaConstants.MODULEEDITOR_SOURCETABLEKEY, ""));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.MODULEEDITOR_TABLEKEY, ""));
		meta.setColumnCount(DomHelper.readInt(element, MetaConstants.MODULEEDITOR_COLUMNCOUNT, 5));
		meta.setGap(DomHelper.readInt(element, MetaConstants.MODULEEDITOR_GAP, 5));
	}

	@Override
	public void save(Document document, Element element, MetaModuleEditor meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.MODULEEDITOR_SOURCETYPE,
				ModuleSourceType.format(meta.getSourceType()), ModuleSourceType.STR_ITEMS);
		DomHelper.writeAttr(element, MetaConstants.MODULEEDITOR_SOURCECAPTION, meta.getSourceCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.MODULEEDITOR_SOURCETABLEKEY, meta.getSourceTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.MODULEEDITOR_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.MODULEEDITOR_COLUMNCOUNT, meta.getColumnCount(), 5);
		DomHelper.writeAttr(element, MetaConstants.MODULEEDITOR_GAP, meta.getGap(), 5);
	}
}
