package com.bokesoft.yes.meta.persist.dom.form.component.control.listview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowAction;

public class MetaRowActionAction extends BaseDomAction<MetaRowAction> {

	@Override
	public void load(Document document, Element element, MetaRowAction meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setContent(DomHelper.readCDATAContent(element).trim().intern());
	}

	@Override
	public void save(Document document, Element element, MetaRowAction meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeCDATAContent(document, element, meta.getContent());
	}

}
