package com.bokesoft.yes.meta.persist.dom.form.component.control.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentExtAction;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaRadioButton;

/**
 * 单选框对象在保存和载入时的相关动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaRadioButtonExtAction extends MetaComponentExtAction<MetaRadioButton> {
	@Override
	public void load(Document document, Element element, MetaRadioButton meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setGroupKey(DomHelper.readAttr(element, MetaConstants.RADIOBUTTON_GROUPKEY, null));
		meta.setGroupHead(DomHelper.readBool(element, MetaConstants.RADIOBUTTON_ISGROUPHEAD, null));
		meta.setSelectedValue(DomHelper.readAttr(element, MetaConstants.RADIOBUTTON_VALUE, null));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.CHECKBOX_ICON, null));
		meta.setSelectedIcon(DomHelper.readAttr(element, MetaConstants.CHECKBOX_SELECTEDICON, null));
		meta.setIconLocation(IconLocationType.parse(DomHelper.readAttr(element, MetaConstants.CHECKBOX_ICONLOCATION, "")));
		meta.setHideButton(DomHelper.readAttr(element, MetaConstants.CHECKBOX_HIDEBUTTON, false));
	}

	@Override
	public void save(Document document, Element element, MetaRadioButton meta, int runType) {

	}
}
