package com.bokesoft.yes.meta.persist.dom.form.component.control.collectionview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionViewRow;

public class MetaCollectionViewRowAction extends MetaComponentAction<MetaCollectionViewRow> {
	
	@Override
	public void load(Document document, Element element, MetaCollectionViewRow meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setSeparatorStyle(DomHelper.readAttr(element, MetaConstants.TABLEROW_SEPARATORSTYLE, ""));
		meta.setSeparatorRadius(DomHelper.readAttr(element, MetaConstants.TABLEROW_SEPARATORRADIUS, -1));
		meta.setSeparatorColor(DomHelper.readAttr(element, MetaConstants.TABLEROW_SEPARATORCOLOR, ""));
		String separatorOffsetStr = DomHelper.readAttr(element, MetaConstants.TABLEROW_SEPARATOROFFEST, "");
		if(separatorOffsetStr != null && separatorOffsetStr.length() > 0){
			meta.setSeparatorOffset(DefSize.parse(separatorOffsetStr));
		}
		meta.setTopMargin(DomHelper.readAttr(element, MetaConstants.TABLEROW_TOPMARGIN, ""));
		meta.setSelectColor(DomHelper.readAttr(element, MetaConstants.TABLEROW_SELECTCOLOR, ""));
		meta.setHighlightColor(DomHelper.readAttr(element, MetaConstants.TABLEROW_HIGHLIGHTCOLOR, ""));
		meta.setBackColor(DomHelper.readAttr(element, MetaConstants.COMMON_BACKCOLOR, ""));
	}

	@Override
	public void save(Document document, Element element, MetaCollectionViewRow meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SEPARATORSTYLE, meta.getSeparatorStyle(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SEPARATORRADIUS, meta.getSeparatorRadius(), -1);
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SEPARATORCOLOR, meta.getSeparatorColor(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SEPARATOROFFEST, 
				meta.getSeparatorOffset() == null ? "" : meta.getSeparatorOffset().toString(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_TOPMARGIN, meta.getTopMargin(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_SELECTCOLOR, meta.getSelectColor(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEROW_HIGHLIGHTCOLOR, meta.getHighlightColor(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_BACKCOLOR, meta.getBackColor(), "");
	}

}
