package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.WebBrowserSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaWebBrowser;

public class MetaWebBrowserAction extends MetaComponentAction<MetaWebBrowser> {
	@Override
	public void load(Document document, Element element, MetaWebBrowser meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setUrlPrefix(DomHelper.readAttr(element, MetaConstants.WEBBROWSER_URLPREFIX, ""));
		meta.setSourceType(WebBrowserSourceType
				.parse(DomHelper.readAttr(element, MetaConstants.WEBBROWSER_SOURCETYPE, WebBrowserSourceType.STR_URL)));
	}

	@Override
	public void save(Document document, Element element, MetaWebBrowser meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.WEBBROWSER_URLPREFIX, meta.getUrlPrefix(), "");
		DomHelper.writeAttr(element, MetaConstants.WEBBROWSER_SOURCETYPE,
				WebBrowserSourceType.format(meta.getSourceType()), WebBrowserSourceType.STR_URL);
	}
}
