package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.DomPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDynamicProperties;
import com.bokesoft.yigo.common.dom.DomHelper;

public class MetaDynamicPropertiesAction extends DomPropertiesAction<MetaDynamicProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaDynamicProperties meta, int runType) {
		meta.setTypeFormula(DomHelper.readAttr(element, MetaConstants.TYPE_FORMULA, ""));
		meta.setTypeDependency(DomHelper.readAttr(element, MetaConstants.TYPE_DEPENDENCY, ""));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaDynamicProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.TYPE_FORMULA, meta.getTypeFormula(), "");
		DomHelper.writeAttr(element, MetaConstants.TYPE_DEPENDENCY, meta.getTypeDependency(), "");
	}

}
