package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownItem;

public class MetaDropdownItemAction extends BaseDomAction<MetaDropdownItem> {

	@Override
	public void load(Document document, Element element, MetaDropdownItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.DROPDOWNITEM_KEY, ""));
		meta.setText(DomHelper.readAttr(element, MetaConstants.DROPDOWNITEM_TEXT, ""));
		meta.setSeparator(DomHelper.readAttr(element, MetaConstants.DROPDOWNITEM_SEPARATOR, false));
	}

	@Override
	public void save(Document document, Element element, MetaDropdownItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.DROPDOWNITEM_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DROPDOWNITEM_TEXT, meta.getText(), "");
		DomHelper.writeAttr(element, MetaConstants.DROPDOWNITEM_SEPARATOR, meta.getSeparator(), false);
	}

}
