package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaColorPicker;

/**
 * 颜色选择对象在保存和载入时的动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaColorPickerAction extends MetaComponentAction<MetaColorPicker> {
	@Override
	public void load(Document document, Element element, MetaColorPicker meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setInitColor(DomHelper.readAttr(element, MetaConstants.COLORPICKER_INITCOLOR, ""));
	}

	@Override
	public void save(Document document, Element element, MetaColorPicker meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COLORPICKER_INITCOLOR, meta.getInitColor(), "");
	}
}
