package com.bokesoft.yes.meta.persist.dom.form.component.bar;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.bar.MetaToolBar;

public class MetaToolBarAction extends MetaComponentAction<MetaToolBar> {
	@Override
	public void load(Document document, Element element, MetaToolBar meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setIsDefault(DomHelper.readAttr(element, MetaConstants.BAR_ISDEFAULT, true));
	}
	
	@Override
	public void save(Document document, Element element, MetaToolBar meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.BAR_ISDEFAULT, meta.getIsDefault(), true);
	}
}
