package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaFormRelation;

public class MetaFormRelationAction extends BaseDomAction<MetaFormRelation> {

	@Override
	public void load(Document document, Element element, MetaFormRelation meta, int runType) {
		meta.setFormKey(DomHelper.readAttr(element,	MetaConstants.FORMRELATION_FORMKEY, ""));
		meta.setDataObjectKey(DomHelper.readAttr(element, MetaConstants.FORMRELATION_DATAOBJECTKEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaFormRelation meta, int runType) {	
		DomHelper.writeAttr(element, MetaConstants.FORMRELATION_FORMKEY, meta.getFormKey(), "");
		DomHelper.writeAttr(element, MetaConstants.FORMRELATION_DATAOBJECTKEY, meta.getDataObjectKey(), "");
	}

}
