package com.bokesoft.yes.meta.persist.dom.form;

import com.bokesoft.yigo.common.def.DeliveryClass;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.def.OperationState;
import com.bokesoft.yigo.common.def.PlatformType;
import com.bokesoft.yigo.common.def.ScreenOrientation;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaForm;

public class MetaFormExtAction extends BaseDomAction<MetaForm> {

	@Override
	public void load(Document document, Element element, MetaForm meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setAliasKey(DomHelper.readAttr(element, MetaConstants.COMMON_ALIAS_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, null));
		meta.setCaptionEn(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN, null));
		meta.setFormType(FormType.parse(DomHelper.readAttr(element, MetaConstants.FORM_FORMTYPE, "")));
		meta.setExtend(DomHelper.readAttr(element, MetaConstants.FORM_EXTEND, ""));
		meta.setAuthenticate(DomHelper.readBool(element, MetaConstants.AUTHENTICATE_FLAG, null));
		meta.setFormulaCaption(DomHelper.readAttr(element, MetaConstants.COMMON_FORMULA_CAPTION, null));
		meta.setAbbrCaption(DomHelper.readAttr(element, MetaConstants.COMMON_ABBR_CAPTION, null));
		meta.setFormulaAbbrCaption(DomHelper.readAttr(element, MetaConstants.COMMON_FORMULA_ABBR_CAPTION, null));
		meta.setFormDisplay(DomHelper.readAttr(element, MetaConstants.COMMON_FORMDISPLAY, false));
		meta.setInitState(OperationState.parse(DomHelper.readAttr(element, MetaConstants.INIT_STATE, "")));
		meta.setViewKey(DomHelper.readAttr(element, MetaConstants.FORM_VIEWKEY, null));
		meta.setLinkedFormKey(DomHelper.readAttr(element, MetaConstants.FORM_LINKEDFORMKEY, null));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, null));
		meta.setPlatform(PlatformType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_PLATFORM, "")));
		meta.setScreenOrientation(ScreenOrientation.parse(DomHelper.readAttr(element, MetaConstants.SCREEN_ORIENTATION, ScreenOrientation.str_unspecified)));
		meta.setHasNavigationBar(DomHelper.readAttr(element, MetaConstants.FORM_HASNAVIGATIONBAR, ""));
		meta.setConfirmClose(DomHelper.readBool(element, MetaConstants.FORM_CONFIRMCLOSE, null));
		meta.setUseVariant(DomHelper.readBool(element, MetaConstants.FORM_USEVARIANT, null));
		meta.setMergeToSource(DomHelper.readAttr(element, MetaConstants.FORM_MERGETOSOURCE, false));
		meta.setStatusBarColor(DomHelper.readAttr(element, MetaConstants.FORM_STATUSBAR_COLOR, null));
		meta.setOffLine(DomHelper.readBool(element, MetaConstants.FORM_OFFLINE, null));
		meta.setDeliveryClass(DeliveryClass.parse(DomHelper.readAttr(element, MetaConstants.FORM_DELIVERYCLASS, null)));
		meta.setTransFormKey(DomHelper.readAttr(element, MetaConstants.FORM_TRANSFORMKEY, null));
	}

	@Override
	public void save(Document document, Element element, MetaForm meta, int runType) {
	
	}

}
