package com.bokesoft.yes.meta.persist.dom.flatcanvas;

import java.io.InputStream;

import org.w3c.dom.Document;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCPaper;

/**
 * 平面图加载
 * 
 * @author chenbinbin
 *
 */
public class MetaFlatCanvasLoad {
	
	public MetaFlatCanvasLoad(int runType) {
		
	}

	/**
	 * 加载平面图配置对象
	 * 
	 * @param resolver  配置文件处理句柄
	 * @param resource 	文件路径
	 * 
	 * @return	平面图配置对象		
	 * 
	 * @throws Exception
	 */
	public MetaFCPaper load(IMetaResolver resolver, String resource) throws Exception {
		InputStream in = resolver.read(resource, 0);
		try {
			if (in != null) {
				Document document = DomHelper.createDocument(in);
				MetaFCPaper metaPaper = new MetaFCPaper();
				metaPaper.loadFromDocument(document);
				return metaPaper;
			}
		} finally {
			if (in != null) {
				in.close();
			}
		}
		return null;
	}
}
