package com.bokesoft.yes.meta.persist.dom.excel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateColumnExpandSourceType;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateColumnExpandType;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumnExpand;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateConstants;

public class MetaExcelColumnExpandAction extends MetaBaseScriptAction<MetaExcelColumnExpand> {
	@Override
	public void load(Document document, Element element, MetaExcelColumnExpand meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setExpandType(ExcelTemplateColumnExpandType.parse(DomHelper.readAttr(element,MetaExcelTemplateConstants.EXPAND_TYPE, "")));
		meta.setSourceType(ExcelTemplateColumnExpandSourceType.parse(DomHelper.readAttr(element, MetaExcelTemplateConstants.EXPAND_SOURCETYPE, "")));
		meta.setItemKey(DomHelper.readAttr(element, MetaExcelTemplateConstants.EXPAND_ITEMKEY, ""));
	}
	
	@Override
	public void save(Document document, Element element, MetaExcelColumnExpand meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.EXPAND_TYPE, ExcelTemplateColumnExpandType.toString(meta.getExpandType()), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.EXPAND_SOURCETYPE, ExcelTemplateColumnExpandSourceType.toString(meta.getSourceType()), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.EXPAND_ITEMKEY, meta.getItemKey(), "");
	}
}
