package com.bokesoft.yes.meta.persist.dom.entry;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.EntryItemType;
import com.bokesoft.yigo.common.def.FormTarget;
import com.bokesoft.yigo.common.def.Media;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;

public class MetaEntryItemAction extends BaseDomAction<MetaEntryItem> {

	@Override
	public void load(Document document, Element element,
			MetaEntryItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setCaptionEn(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN, ""));
		meta.setShortKeys(DomHelper.readAttr(element, MetaConstants.ENTRY_SHORTKEYS, ""));
		meta.setType(EntryItemType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_TYPE, "")));
		meta.setFormKey(DomHelper.readAttr(element, MetaConstants.COMMON_FORMKEY, ""));
		meta.setEnable(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE, ""));
		meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, ""));
		meta.setParameters(DomHelper.readAttr(element, MetaConstants.ENTRY_PARAMETERS, ""));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, ""));
		meta.setView(DomHelper.readAttr(element, MetaConstants.ENTRY_VIEW, ""));
		meta.setMedia(Media.valueOf(DomHelper.readAttr(element, MetaConstants.ENTRY_MEDIA, "")));
		meta.setSize(DomHelper.readAttr(element, MetaConstants.ENTRY_SIZE, ""));
		meta.setSingle(DomHelper.readAttr(element, MetaConstants.ENTRY_SINGLE, true));
		meta.setProvider(DomHelper.readAttr(element, MetaConstants.ENTRY_PROVIDER, ""));
		meta.setTarget(FormTarget.parse(DomHelper.readAttr(element, MetaConstants.ENTRY_TARGET, FormTarget.STR_NEWTAB)));
		meta.setRightsRelation(DomHelper.readAttr(element, MetaConstants.ENTRY_RIGHTSRELATION, ""));
		meta.setIconCode(DomHelper.readAttr(element, MetaConstants.COMMON_ICON_CODE, ""));
		meta.setTCode(DomHelper.readAttr(element, MetaConstants.ENTRY_TCODE, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaEntryItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION_EN, meta.getCaptionEn(), "");
		DomHelper.writeAttr(element, MetaConstants.ENTRY_SHORTKEYS, meta.getShortKeys(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_TYPE, EntryItemType.toString(meta.getType()), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_FORMKEY, meta.getFormKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ENABLE, meta.getEnable(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE, meta.getVisible(), "");
		DomHelper.writeAttr(element, MetaConstants.ENTRY_PARAMETERS, meta.getParameters(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.ENTRY_VIEW, meta.getView(), "");
		DomHelper.writeAttr(element, MetaConstants.ENTRY_MEDIA, Media.toString(meta.getMedia()), "");
		DomHelper.writeAttr(element, MetaConstants.ENTRY_SIZE, meta.getSize(), "");
		DomHelper.writeAttr(element, MetaConstants.ENTRY_SINGLE, meta.isSingle(), true);
		DomHelper.writeAttr(element, MetaConstants.ENTRY_PROVIDER, meta.getProvider(), "");
		DomHelper.writeAttr(element, MetaConstants.ENTRY_TARGET, FormTarget.toString(meta.getTarget()), FormTarget.STR_NEWTAB);
		DomHelper.writeAttr(element, MetaConstants.ENTRY_RIGHTSRELATION, meta.getRightsRelation(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON_CODE,meta.getIconCode(), "");
		DomHelper.writeAttr(element, MetaConstants.ENTRY_TCODE, meta.getTCode(), "");
	}

}
