package com.bokesoft.yes.meta.persist.dom.deploy;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.deploy.MetaDeploy;

public class MetaDeployAction extends BaseDomAction<MetaDeploy> {

	@Override
	public void load(Document document, Element element, MetaDeploy meta, int runType) {
		meta.setIncludedRightsSchema(DomHelper.readAttr(element, MetaConstants.DEPLOY_INCLUDED_RIGHTS_SCHEMA, false));
	}

	@Override
	public void save(Document document, Element element, MetaDeploy meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.DEPLOY_INCLUDED_RIGHTS_SCHEMA, meta.isIncludedRightsSchema(), false);
	}

}
