package com.bokesoft.yes.meta.persist.dom.datamigration;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamigration.MetaDMConstants;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceTable;

public class MetaDMSourceTableAction extends BaseDomAction<MetaDMSourceTable> {

	@Override
	public void load(Document document, Element element,
			MetaDMSourceTable meta, int runType) {
		meta.setTableKey(DomHelper.readAttr(element, MetaDMConstants.TABLEKEY, ""));
		meta.setIsPrimary(DomHelper.readAttr(element, MetaDMConstants.ISPRIMARY, false));
		meta.setKey(DomHelper.readAttr(element, "Key", ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaDMSourceTable meta, int runType) {
		DomHelper.writeAttr(element, MetaDMConstants.TABLEKEY, meta.getSourceTableKey(), "");
		DomHelper.writeAttr(element, MetaDMConstants.ISPRIMARY, meta.getIsPrimary(), false);
		DomHelper.writeAttr(element, "Key", meta.getKey(), "");
	}

}
