package com.bokesoft.yes.meta.persist.dom.datamap;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.datamap.split.MetaSplitAction;
import com.bokesoft.yes.meta.persist.dom.datamap.split.MetaSplitGroupAction;
import com.bokesoft.yes.meta.persist.dom.datamap.split.MetaSplitProcessAction;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamap.diagram.MetaFeedbackCollection;
import com.bokesoft.yigo.meta.datamap.diagram.MetaFeedbackField;
import com.bokesoft.yigo.meta.datamap.diagram.MetaFeedbackObject;
import com.bokesoft.yigo.meta.datamap.diagram.MetaFeedbackTable;
import com.bokesoft.yigo.meta.datamap.error.MetaDataMapErrorInfo;
import com.bokesoft.yigo.meta.datamap.error.MetaDataMapErrorInfoCollection;
import com.bokesoft.yigo.meta.datamap.relatedatamap.MetaRelateDataMap;
import com.bokesoft.yigo.meta.datamap.relatedatamap.MetaRelateDataMapCollection;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceField;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceTable;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceTableCollection;
import com.bokesoft.yigo.meta.datamap.split.MetaSplit;
import com.bokesoft.yigo.meta.datamap.split.MetaSplitGroup;
import com.bokesoft.yigo.meta.datamap.split.MetaSplitProcess;
import com.bokesoft.yigo.meta.datamap.target.MetaFeedback;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetField;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetTable;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetTableCollection;

public class MetaMapActionMap extends MetaActionMap {
	private MetaMapActionMap() {
		super();
	}
	
	@Override
	protected Object[][] getActionLookupTable() {
		MetaBaseScriptAction<?> metaScriptAction = new MetaBaseScriptAction<MetaBaseScript>();
		return new Object[][] {
				{ MetaMap.TAG_NAME, new MetaMapAction() },
				{ MetaFeedback.TAG_NAME, new MetaFeedbackAction() },
				{ MetaSourceField.TAG_NAME, new MetaSourceFieldAction() },
				{ MetaSourceTable.TAG_NAME, new MetaSourceTableAction() },
				{ MetaSourceTableCollection.TAG_NAME, new MetaSourceTableCollectionAction() },
				{ MetaTargetField.TAG_NAME, new MetaTargetFieldAction() },
				{ MetaTargetTable.TAG_NAME, new MetaTargetTableAction() },
				{ MetaTargetTableCollection.TAG_NAME, new MetaTargetTableCollectionAction() },
				{ MetaFeedbackCollection.TAG_NAME, new MetaFeedbackCollectionAction() },
				{ MetaFeedbackObject.TAG_NAME, new MetaFeedbackObjectAction() },
				{ MetaFeedbackTable.TAG_NAME, new MetaFeedbackTableAction() },
				{ MetaFeedbackField.TAG_NAME, new MetaFeedbackFieldAction() },
				{ MetaRelateDataMap.TAG_NAME, new MetaRelateDataMapAction() },
				{ MetaRelateDataMapCollection.TAG_NAME, new MetaRelateDataMapCollectionAction() },
				{ MetaSplit.TAG_NAME, new MetaSplitAction() },
				{ MetaSplitGroup.TAG_NAME, new MetaSplitGroupAction() },
				{ MetaSplitProcess.TAG_NAME, new MetaSplitProcessAction() },
				{ MetaMapConstants.FEEDBACK_POST_TRIGGER, metaScriptAction },
				{ MetaMapConstants.FEEDBACK_POST_FORMULA_TRIGGER, metaScriptAction },
				{ MetaMapConstants.MAP_POSTPROCESS, metaScriptAction },
				{ MetaDataMapErrorInfoCollection.TAG_NAME, new MetaDataMapErrorInfoCollectionAction()},
				{ MetaDataMapErrorInfo.TAG_NAME, new MetaDataMapErrorInfoAction()}
			};
	}

	private static MetaMapActionMap instance = null;
	public static MetaMapActionMap getInstance() {
		if ( instance == null ) {
			instance = new MetaMapActionMap();
		}
		return instance;
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}
}
