package com.bokesoft.yes.meta.persist.dom.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaInplaceToolbar;

public class MetaInplaceToolbarAction extends BaseDomAction<MetaInplaceToolbar> {

	public void save(Document doc, Element node, MetaInplaceToolbar meta, int runType) {
		Element element = (Element)node;
		MetaInplaceToolbar metaInplaceToolbar = (MetaInplaceToolbar)meta;
		DomHelper.writeAttr(element, MetaConstants.COMMON_TAG, metaInplaceToolbar.getTag(), "");
		DomHelper.writeAttr(element, MetaConstants.INPLACE_TOOLBAR_HANDLER, metaInplaceToolbar.getHandler(), "");
		DomHelper.writeAttr(element, MetaConstants.INPLACE_TOOLBAR_DESCRIPTION, metaInplaceToolbar.getDescription(), "");
	}

	public void load(Document doc, Element node, MetaInplaceToolbar meta, int runType) {
		Element element = (Element)node;
		MetaInplaceToolbar metaInplaceToolbar = (MetaInplaceToolbar)meta;
		metaInplaceToolbar.setTag(DomHelper.readAttr(element, MetaConstants.COMMON_TAG, ""));
		metaInplaceToolbar.setHandler(DomHelper.readAttr(element, MetaConstants.INPLACE_TOOLBAR_HANDLER, ""));
		metaInplaceToolbar.setDescription(DomHelper.readAttr(element, MetaConstants.INPLACE_TOOLBAR_DESCRIPTION, ""));
	}
}
