package com.bokesoft.yes.meta.persist.dom.calendar;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.calendar.MetaWorkingCalendar;

public class MetaWorkingCalendarAction extends
		BaseDomAction<MetaWorkingCalendar> {

	@Override
	public void load(Document document, Element element,
			MetaWorkingCalendar meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY,
				""));
		meta.setWeekend(DomHelper.readAttr(element,
				MetaConstants.CANLENDER_WEEKEND, ""));
		meta.setOfficeHour(DomHelper.readAttr(element,
				MetaConstants.CANLENDER_OFFICE_HOUR, "00:00-23:59"));
		meta.setCluster(DomHelper.readAttr(element,
				MetaConstants.CANLENDER_CLUSTER, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaWorkingCalendar meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY,
				meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.CANLENDER_WEEKEND,
				meta.getWeekend(), "");
		DomHelper.writeAttr(element, MetaConstants.CANLENDER_OFFICE_HOUR,
				meta.getOfficeHour(), "00:00-23:59");
		DomHelper.writeAttr(element, MetaConstants.CANLENDER_CLUSTER,
				meta.getCluster(), "");
	}

}
