package com.bokesoft.yes.meta.persist.dom.calendar;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.calendar.MetaDay;

public class MetaDayAction extends BaseDomAction<MetaDay> {

	@Override
	public void load(Document document, Element element, MetaDay meta, int runType) {
		meta.setDay(DomHelper.readAttr(element,
				MetaConstants.CANLENDER_DAY, -1));
		meta.setMonth(DomHelper.readAttr(element,
				MetaConstants.CANLENDER_MONTH, -1));
		meta.setYear(DomHelper.readAttr(element,
				MetaConstants.CANLENDER_YEAR, -1));
		meta.setOffDay(DomHelper.readAttr(element,
				MetaConstants.CANLENDER_OFFDAY, false));
	}

	@Override
	public void save(Document document, Element element, MetaDay meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.CANLENDER_DAY,
				meta.getDay(), -1);
		DomHelper.writeAttr(element, MetaConstants.CANLENDER_MONTH,
				meta.getMonth(), -1);
		DomHelper.writeAttr(element, MetaConstants.CANLENDER_YEAR,
				meta.getYear(), -1);
		DomHelper.writeAttr(element, MetaConstants.CANLENDER_OFFDAY,
				meta.isOffDay(), false);
	}

}
