package com.bokesoft.yes.meta.persist.dom.businessdiagram;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.businessdiagram.action.MetaBusinessDiagramAction;
import com.bokesoft.yes.meta.persist.dom.businessdiagram.action.MetaBusinessDiagramLineAction;
import com.bokesoft.yes.meta.persist.dom.businessdiagram.action.MetaBusinessDiagramLineCollectionAction;
import com.bokesoft.yes.meta.persist.dom.businessdiagram.action.MetaBusinessDiagramNodeAction;
import com.bokesoft.yes.meta.persist.dom.businessdiagram.action.MetaBusinessDiagramNodeCollectionAction;
import com.bokesoft.yigo.meta.businessdiagram.MetaBusinessDiagram;
import com.bokesoft.yigo.meta.businessdiagram.MetaBusinessDiagramLine;
import com.bokesoft.yigo.meta.businessdiagram.MetaBusinessDiagramLineCollection;
import com.bokesoft.yigo.meta.businessdiagram.MetaBusinessDiagramNode;
import com.bokesoft.yigo.meta.businessdiagram.MetaBusinessDiagramNodeCollection;

public class MetaBusinessDiagramActionMap extends MetaActionMap {

	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] {
				{ MetaBusinessDiagram.TAG_NAME, new MetaBusinessDiagramAction() },
				{ MetaBusinessDiagramNodeCollection.TAG_NAME, new MetaBusinessDiagramNodeCollectionAction() },
				{ MetaBusinessDiagramNode.TAG_NAME, new MetaBusinessDiagramNodeAction() },
				{ MetaBusinessDiagramLineCollection.TAG_NAME, new MetaBusinessDiagramLineCollectionAction() },
				{ MetaBusinessDiagramLine.TAG_NAME, new MetaBusinessDiagramLineAction() }
		};
	}
	
	private static MetaBusinessDiagramActionMap INSTANCE = null;
	public static MetaBusinessDiagramActionMap getInstance() {
		if (INSTANCE == null) {
			synchronized (MetaBusinessDiagramActionMap.class) {
				if (INSTANCE == null) {
					INSTANCE = new MetaBusinessDiagramActionMap();
				}
			}
		}

		return INSTANCE;
	}
	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}
}
